<?php
/* --------------------------------------------------------------
 ConfigurationGroupRepository.php 2020-02-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Repositories;

use Gambio\Core\Configuration\Models\Read\Collections\ConfigurationGroup;
use Gambio\Core\Configuration\Models\Read\ConfigurationGroupId;

/**
 * Interface ConfigurationGroupRepository
 * @package Gambio\Core\Configuration\Repositories
 */
interface ConfigurationGroupRepository
{
    /**
     * Returns a list of configurations.
     * The list is filtered by the given configuration group.
     *
     * @param ConfigurationGroupId $group
     * @param array                $exclude
     *
     * @return ConfigurationGroup
     */
    public function getByGroup(ConfigurationGroupId $group, array $exclude = []): ConfigurationGroup;
}